﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class CustomerWithParameterizedProperty

    Private custAccount As String
    Private custFirstName As String
    Private custLastName As String
    Private custDefaultQuantity As Integer = 12

    '若要创建参数化属性，只需将参数添加到
    '属性语句，在本例中为“Multiplier”：
    Public Property DefaultQuantity(ByVal Multiplier As Integer) As Integer
        Get
            'Property Get 过程通常不使用传入的
            '参数，但在参数化属性的情况下
            '则不然。相应参数的处理方式正如普通的
            '传递参数一样：
            Return custDefaultQuantity * Multiplier
        End Get
        Set(ByVal Value As Integer)
            custDefaultQuantity = Value
        End Set
    End Property

#Region "Customer 的属性"

    Public Property AccountNumber() As String
        Get
            Return custAccount
        End Get
        Set(ByVal Value As String)
            custAccount = Value
        End Set
    End Property

    Public Property FirstName() As String
        Get
            Return custFirstName
        End Get
        Set(ByVal Value As String)
            custFirstName = Value
        End Set
    End Property

    Public Property LastName() As String
        Get
            Return custLastName
        End Get
        Set(ByVal Value As String)
            custLastName = Value
        End Set
    End Property
#End Region
End Class
